<?php

namespace App\Modules\LeadBookingService\Domain;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\TypeRate\Domain\IdTypeRate;
use App\Modules\UserCountry\Domain\IdUserCountry;

class LeadBookingService
{

    /** constructor */
    public function __construct(
        private LeadBookingServiceQuantity $quantity,
        private LeadBookingServiceType $type,
        private LeadBookingServiceStatus $status,
        private IdLeadBookingTour $idLeadBookingTour,
        private Id $idService,
        private ?IdLeadBookingService $id = null
    ) {
    }

    public function getQuantity(): LeadBookingServiceQuantity
    {
        return $this->quantity;
    }
    public function getType(): LeadBookingServiceType
    {
        return $this->type;
    }
    public function getStatus(): LeadBookingServiceStatus
    {
        return $this->status;
    }
    public function getIdLeadBookingTour(): IdLeadBookingTour
    {
        return $this->idLeadBookingTour;
    }
    public function getIdService(): Id
    {
        return $this->idService;
    }
    public function getId(): IdLeadBookingService
    {
        return $this->id;
    }
}
