<?php

namespace App\Modules\LeadBookingTour\Application\Index;

use App\Modules\LeadBookingTour\Application\Index\LeadBookingTourIndexerResponse;
use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;

final class LeadBookingTourIndexer
{
    public function __construct(private LeadBookingTourRepository $repository)
    {
    }

    public function __invoke(IdLeadBookingTour $idLeadBookingTour): LeadBookingTourIndexerResponse
    {
        return new LeadBookingTourIndexerResponse($this->repository->index($idLeadBookingTour));
    }
}
