<?php

namespace App\Modules\Machupicchu\Application\AvailabilityList;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class MachupicchuAvailabilityListerQuery implements Query
{
    public function __construct(
        private string $year,
        private int $idRoute,
        private int $month
    ) {
    }

    public function year(): string
    {
        return $this->year;
    }
    public function idRoute(): int
    {
        return $this->idRoute;
    }
    public function month(): int
    {
        return $this->month;
    }
}
