<?php

namespace App\Modules\Machupicchu\Infraestructure;

use App\Modules\Machupicchu\Domain\Availability\AvailabilityList;
use App\Modules\Machupicchu\Domain\Availability\MachupicchuAvailabilityRepository;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;

class GuzzleMachupicchuAvailabilityRepository implements MachupicchuAvailabilityRepository
{

    public function find(string $year, int $idRoute, int $month)
    {
        $client = new Client();

        $url = 'https://www.machupicchu.gob.pe:8000/boleto/disponibilidad';
        $data = [
            'anio' => $year,
            'idRuta' => $idRoute,
            'mes' => $month
        ];
        try {
            $res = $client->request('POST', $url, [ 'json' => $data ]);
            return AvailabilityList::fromText($res->getBody()->__toString());
        } catch (ClientException $e) {
            new BadRequestException($e->getMessage());
        }
    }
}
