<?php

namespace App\Modules\ModuleNotification\Infraestructure;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\ModuleNotification\Domain\ModuleNotification;
use App\Modules\ModuleNotification\Domain\ModuleNotificationRepository;
use App\Modules\ModuleNotification\Domain\IdModuleNotification;
use App\Modules\ModuleNotification\Domain\InsertModuleNotification;
use App\Modules\ModuleNotification\Domain\UpdateModuleNotification;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlModuleNotificationRepository implements ModuleNotificationRepository
{

    public function find(string $action, int $limit, int $offset)
    {
        return Requester::requestSelect(
            'CALL sp_module_notification_list(?,?,?,@sts,@cod,@msg)',
            [
                $action,
                $limit,
                $offset
            ]
        );
    }

    public function index(IdModuleNotification $id)
    {
        return Requester::requestSelect(
            'CALL sp_module_notification_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(InsertModuleNotification $value)
    {
        return Requester::requestInsert(
            'CALL sp_module_notification_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getDescription()->value(),
                $value->getType()->value(),
                $value->getModule()->value(),
                $value->getIdAdminCreate()->value(),
            ]
        );
    }

    public function update(UpdateModuleNotification $value)
    {
        return Requester::requestUpdate(
            'CALL sp_module_notification_update(?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getStatus()->value(),
                $value->getIdAdmin()->value(),
            ]
        );
    }

    // public function delete(IdModuleNotification $id) {
    //     return Requester::requestUpdate(
    //         'CALL sp_module_notification_delete(?,@sts,@cod,@msg)',
    //         [
    //             $id->getValue(),
    //         ]
    //     );
    // }
}
