<?php

namespace App\Modules\ModuleNotificationParam\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\ModuleNotification\Domain\IdModuleNotification;
use App\Modules\Modules\Domain\Structure\ParamModule;
use App\Modules\Modules\Domain\Structure\StructureModule;

class InsertModuleNotificationParam
{

    /** constructor */
    public function __construct(
        private IdModuleNotification $idModuleNotification,
        private ModuleNotificationParamKey $key,
        private ModuleNotificationParamValue $value
    ) {
    }

    public function idModuleNotification(): IdModuleNotification
    {
        return $this->idModuleNotification;
    }
    public function key(): ModuleNotificationParamKey
    {
        return $this->key;
    }
    public function value(): ModuleNotificationParamValue
    {
        return $this->value;
    }
    public function setValue($value)
    {
        $this->value = new ModuleNotificationParamValue($value);
    }

    public static function fromParamModule(
        IdModuleNotification $idModuleNotification,
        $value,
        ParamModule $param
    ) {
        return new self(
            $idModuleNotification,
            new ModuleNotificationParamKey($param->key()),
            new ModuleNotificationParamValue($param->ensureIsValid($value))
        );
    }

    /**
     * @return array([InsertModuleNotificationParam $...])
     */
    public static function fromModule(
        IdModuleNotification $idModuleNotification,
        StructureModule $module
    ) {
        $turn = [];
        foreach ($module->collection() as $param) {
            $turn[$param->key()] = self::fromParamModule(
                $idModuleNotification,
                $param->defaultValue(),
                $param
            );
        }
        return $turn;
    }
}
