<?php

namespace App\Modules\Passenger\Domain;

use DateTime;
use InvalidArgumentException;

class PassengerDOB
{
    protected static $format = 'Y-m-d';
    private DateTime $value;

    public function __construct(DateTime | string $value)
    {
        if ($value instanceof DateTime) {
            $this->value = $value;
        } else {
            $this->ensureIsValidDate($value);
            $this->value = DateTime::createFromFormat(self::$format, $value);
        }
    }

    public function getValue()
    {
        return $this->value;
    }

    public function value():string
    {
        return $this->value->format(self::$format);
    }

    public function __toString():string
    {
        return $this->value();
    }

    private function ensureIsValidDate(string $date): void
    {
        $dt = DateTime::createFromFormat(self::$format, $date);
        if (!$dt || $dt->format(self::$format) !== $date) {
            throw new InvalidArgumentException(sprintf('%s does not allow the value %s.', static::class, $date));
        }
    }
}
