<?php

namespace App\Modules\Passenger\Infraestructure;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\Passenger;
use App\Modules\Passenger\Domain\PassengerImageDocument1;
use App\Modules\Passenger\Domain\PassengerImageDocument2;
use App\Modules\Passenger\Domain\PassengerRepository;
use App\Modules\Shared\Application\ActionHandler;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlPassengerRepository implements PassengerRepository
{
    
    public function updateDocuments(
        IdPassenger $idPassenger,
        PassengerImageDocument1 $passengerImageDocument1,
        PassengerImageDocument2 $passengerImageDocument2,
    ) {
        $data = DB::select('CALL sp_passenger_index(?,?,?,?,?)', [ $idPassenger->value(), '', '', '', '' ])[0];
        $params = [
            $data->Id_Passenger,
            $data->Passenger_Name,
            $data->Passenger_LastName,
            $data->Passenger_Email,
            $data->Passenger_Phone,
            $data->Passenger_Gender,
            $data->Passenger_DOB,
            $data->Passenger_NoDocument,
            $data->Passenger_Restriction,
            $data->Passenger_Extras,
            $passengerImageDocument1->value(),
            $passengerImageDocument2->value(),
            $data->Passenger_Status,
            $data->Id_TypeDocument,
            $data->Id_UserCountry
        ];
        return (new ActionHandler())->handle(
            DB::select('call sp_passenger_update_all(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $params)
        );
    }

    public function insert(Passenger $passenger)
    {
        $response = Requester::requestInsertAlter(
            'CALL `sp_passenger_insert_alter`(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $passenger->name()->getValue(),
                $passenger->lastName()->getValue(),
                $passenger->email()->getValue(),
                $passenger->phoneCode()->getValue(),
                $passenger->phone()->getValue(),
                $passenger->gender()->getValue(),
                $passenger->dob()->getValue(),
                $passenger->noDocument()->getValue(),
                $passenger->restriction()->value(),
                $passenger->extras()->value(),
                $passenger->status()->getValue(),
                $passenger->idBooking()->value(),
                $passenger->idTypeDocument()->value(),
                $passenger->idTypeRate()->value(),
                $passenger->idUserCountry()->value(),
            ]
        );
        return new IdPassenger($response->id());
    }
}
