<?php

namespace App\Modules\PassengerReview\Application;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\PassengerReview\Domain\PassengerReviewRepository;

class PassengerReviewFinderByGroupPassenger
{

    private PassengerReviewRepository $repository;

    public function __construct(PassengerReviewRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroupPassenger $idGroupPassenger)
    {
        return $this->repository->passengerFindByGroupPassenger($idGroupPassenger);
    }
}
