<?php

namespace App\Modules\PaxInformation\Domain;

final class UpdatePaxInformation
{

    public function __construct(
        private PaxInformationDateExpire $expire,
        private PaxInformationDescription $description,
        private PaxInformationStatus $status,
        private IdPaxInformation $id
    ) {
        $this->description = $description;
        $this->status = $status;
        $this->id = $id;
    }

    public function expire(): PaxInformationDateExpire
    {
        return $this->expire;
    }

    public function description():PaxInformationDescription
    {
        return $this->description;
    }

    public function status():PaxInformationStatus
    {
        return $this->status;
    }

    public function id():IdPaxInformation
    {
        return $this->id;
    }
}
