<?php

namespace App\Modules\PaxInformation\Infraestructure;

use App\Modules\PaxInformation\Domain\PaxInformationSearchTokenRepository;
use App\Modules\PaxInformation\Domain\PaxInformationToken;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPaxInformationSearchTokenRepository implements PaxInformationSearchTokenRepository {

    public function findToken(PaxInformationToken $token) {
        return Requester::requestSelect(
            'CALL sp_pax_information_search_token(?,@sts,@cod,@msg)',
            [
                $token->value()
            ]
        );
    }

}
