<?php

namespace App\Modules\PaxInformationPassenger\Infraestructure\Validators;

class PaxInformationPassengerTokenValidators
{
    public const UPDATE = [
        'Id_PaxInformationPassenger'  => 'required|int',
        'Id_Passenger'                => 'required|int',
        'Passenger_Name'              => 'required|string|max:100',
        'Passenger_LastName'          => 'required|string|max:100',
        'Passenger_Email'             => 'string|max:250',
        'Passenger_PhoneCode'         => 'string|max:10',
        'Passenger_Phone'             => 'string|max:50',
        'Passenger_Gender'            => 'required|int',
        'Passenger_DOB'               => 'required|string',
        'Passenger_NoDocument'        => 'required|string|max:20',
        'Passenger_Restriction'       => 'required|string',
        'Passenger_Extras'            => 'string',
        'Passenger_ImgDocument1'      => 'image|mimes:jpeg,jpg,png|max:25120',
        'Id_TypeDocument'             => 'required|int',
        'Id_UserCountry'              => 'required|int'
    ];
}
