<?php

namespace App\Modules\Question\Infraestructure;

use App\Modules\Question\Domain\Question;
use App\Modules\Question\Domain\QuestionRepository;
use Illuminate\Support\Facades\DB;

class MysqlQuestionRepository implements QuestionRepository {

    public function update(Question $question) {
        return DB::select(
            'call sp_question_update(?,?,?,?,?,?,?,?,?)',
            [
                $question->getId()->getValue(),
                $question->getName()->getValue(),
                $question->getAbrv()->getValue(),
                $question->getType()->getValue(),
                $question->getValues()->value(),
                $question->getWeight()->value(),
                $question->getGeneral()->value(),
                $question->getIdTypeProvider()->getValue(),
                $question->getStatus()->getValue(),
            ]
        );
    }

    public function insert(Question $question) {
        return DB::select(
            'call sp_question_insert(?,?,?,?,?,?,?,?)',
            [
                $question->getName()->getValue(),
                $question->getAbrv()->getValue(),
                $question->getType()->getValue(),
                $question->getValues()->value(),
                $question->getWeight()->value(),
                $question->getGeneral()->value(),
                $question->getIdTypeProvider()->getValue(),
                $question->getStatus()->getValue(),
            ]
        );
    }
}