<?php

namespace App\Modules\ReviewNotification\Application\Accept;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\ReviewNotification\Domain\AcceptReviewNotification;
use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationDescription;
use App\Modules\ReviewNotification\Domain\ReviewNotificationResponse;
use App\Modules\ReviewNotification\Domain\ReviewNotificationStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReviewNotificationAccepterQueryHandler implements QueryHandler
{
    public function __construct(private ReviewNotificationAccepter $updater)
    {
    }

    public function __invoke(ReviewNotificationAccepterQuery $query): ReviewNotificationAccepterResponse
    {
        $model = new AcceptReviewNotification(
            new IdReviewNotification($query->getId()),
            new ReviewNotificationResponse($query->getResponse()),
            new IdAdmin($query->getIdAdmin()),
        );
        return $this->updater->__invoke($model);
    }
}
