<?php

namespace App\Modules\ReviewNotification\Application\Delete;

use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReviewNotificationDeleterQueryHandler implements QueryHandler
{
    public function __construct(private ReviewNotificationDeleter $inserter)
    {
    }

    public function __invoke(ReviewNotificationDeleterQuery $query): ReviewNotificationDeleterResponse
    {
        return $this->inserter->__invoke(new IdReviewNotification($query->getId()));
    }
}
