<?php

namespace App\Modules\ReviewNotification\Application\List;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\ReviewNotification\Application\List\ReviewNotificationListerResponse;
use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;

final class ReviewNotificationLister
{
    public function __construct(private ReviewNotificationRepository $repository)
    {
    }

    public function __invoke(IdGroupPassenger $idGroupPassenger, string $action): ReviewNotificationListerResponse
    {
        return new ReviewNotificationListerResponse($this->repository->find($idGroupPassenger, $action));
    }
}
