<?php

namespace App\Modules\ReviewNotification\Application\Update;

use App\Modules\ReviewNotification\Application\Update\ReviewNotificationUpdaterResponse;
use App\Modules\ReviewNotification\Domain\ReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;
use App\Modules\ReviewNotification\Domain\UpdateReviewNotification;

final class ReviewNotificationUpdater
{
    public function __construct(private ReviewNotificationRepository $repository)
    {
    }

    public function __invoke(UpdateReviewNotification $reviewNotification): ReviewNotificationUpdaterResponse
    {
        return new ReviewNotificationUpdaterResponse($this->repository->update($reviewNotification));
    }
}
