<?php

namespace App\Modules\ReviewNotification\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ReviewNotificationUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private string $reviewNotificationDescription,
        private int $reviewNotificationStatus
    ) {
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function getDescription(): string
    {
        return $this->reviewNotificationDescription;
    }
    public function getStatus(): int
    {
        return $this->reviewNotificationStatus;
    }
}
