<?php

namespace App\Modules\Tour\Application\Create;

use App\Modules\Tour\Application\Create\TourInserterResponse;
use App\Modules\Tour\Domain\Tour;
use App\Modules\Tour\Domain\TourRepository;

final class TourInserter
{
    public function __construct(private TourRepository $repository)
    {
    }

    public function __invoke(Tour $tour): TourInserterResponse
    {
        return new TourInserterResponse($this->repository->insert($tour));
    }
}
