<?php

namespace App\Modules\Tour\Application\Update;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\City\Domain\IdCity;
use App\Modules\Country\Domain\IdCountry;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\Tour\Domain\Tour;
use App\Modules\Tour\Domain\TourAddress;
use App\Modules\Tour\Domain\TourContactName;
use App\Modules\Tour\Domain\TourContactPhone;
use App\Modules\Tour\Domain\TourEmail;
use App\Modules\Tour\Domain\TourGender;
use App\Modules\Tour\Domain\TourLastName;
use App\Modules\Tour\Domain\TourName;
use App\Modules\Tour\Domain\TourNoDocument;
use App\Modules\Tour\Domain\TourPhone;
use App\Modules\Tour\Domain\TourPhoneCode;
use App\Modules\Tour\Domain\TourStatus;
use App\Modules\Tour\Domain\TourType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\State\Domain\IdState;
use App\Modules\Tour\Domain\TourAnticipation;
use App\Modules\Tour\Domain\TourAnticipationType;
use App\Modules\Tour\Domain\TourAvailability;
use App\Modules\Tour\Domain\TourAvailabilityStatus;
use App\Modules\Tour\Domain\TourCode;
use App\Modules\Tour\Domain\TourColor;
use App\Modules\Tour\Domain\TourDuration;
use App\Modules\Tour\Domain\TourMinPax;
use App\Modules\Tour\Domain\TourScore;
use App\Modules\Tour\Domain\TourUrlThumbnail;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\TypeTour\Domain\IdTypeTour;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class TourUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private TourUpdater $updater)
    {
    }

    public function __invoke(TourUpdaterQuery $query): TourUpdaterResponse
    {
        $model = new Tour(
            new TourCode($query->code()),
            new TourName($query->name()),
            new TourUrlThumbnail($query->urlThumbnail()),
            new TourDuration($query->duration()),
            new TourMinPax($query->minPax()),
            new TourAvailability($query->availability()),
            new TourAvailabilityStatus($query->availabilityStatus()),
            new TourAnticipation($query->anticipation()),
            new TourAnticipationType($query->anticipationType()),
            new TourColor($query->color()),
            new TourScore(0),
            new TourStatus($query->status()),
            new IdCategoryTour($query->idCategoryTour()),
            new IdTypeTour($query->idTypeTour()),
            new IdCountry($query->idCountry()),
            new IdState($query->idState()),
            new IdCity($query->idCity()),
            new IdTour($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
