<?php

namespace App\Providers\ExcelEntrancesReport;

use App\Http\Helpers\DateTime;

class EntrancesCells {

    private function titleMerge ($text) { return [
        [ 'action' => 'wrap' ],
        [ 'action' => 'border' ],
        [ 'action' => 'print', 'text' => $text ],
        [ 'action' => 'bold'],
        [ 'action' => 'merge', 'lines' => 1 ],
        [ 'action' => 'border' ],
    ]; }
    private function title ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'border' ], [ 'action' => 'print', 'text' => $text ], ['action' => 'bold']]; }
    private function titleNoBorders ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'print', 'text' => $text ], ['action' => 'bold'], [ 'action' => 'merge', 'lines' => 1 ],]; }
    private function column ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'border' ], [ 'action' => 'print', 'text' => $text ]]; }
    private function columnMerge ($text) { return [
        [ 'action' => 'wrap' ],
        [ 'action' => 'border' ],
        [ 'action' => 'print', 'text' => $text ],
        [ 'action' => 'merge', 'lines' => 1 ],
        [ 'action' => 'border' ],
    ]; }

    

    private function createUpgrades (array $upgrades) {
        return array_merge (
            [
                [
                    $this->title ('N°'),
                    $this->title ('FECHA DE PAGO'),
                    $this->title ('NOMBRE COMPLETO'),
                    $this->title ('TIPO DOC.'),
                    $this->title ('DOCUMENTO'),
                    $this->title ('RUTA'),
                    $this->title ('FECHA DE SALIDA RUTA'),
                    $this->title ('FECHA INGRESO'),
                    $this->title ('HORARIOS DE INGRESO'),
                    $this->title ('INGRESO'),
                    $this->title ('CÓDIGO'),
                    $this->title ('MONTO'),
                    $this->title ('ESTADO'),
                    $this->title ('VENDEDOR'),
                    $this->title ('RESPONSABLE'),
                    $this->title ('OBSERVACIONES'),
                ] 
            ],
            array_map (
                function ($curr, $key) {
                    return [
                        $this->column ($key + 1),                                               // 10
                        $this->column (
                            self::purchased($curr) ? 
                            DateTime::dateTimeTransform($curr->BookingExtraPassenger_DatePurchase) :
                            '-'
                        ),              // 20
                        $this->column ("$curr->Passenger_Name $curr->Passenger_LastName"),      // 30
                        $this->column ($curr->TypeDocument_Name),                               // 14
                        $this->column ($curr->Passenger_NoDocument),                            // 14
                        $this->column ($curr->BookingTour_TourName),                            // 20
                        $this->column (DateTime::dateTransform($curr->BookingTour_DateStart)),  // 20
                        $this->column (
                            self::purchased($curr) ?
                            DateTime::dateTransform($curr->DateEntryStart) :
                            '-'
                        ),   
                        $this->column (
                            self::purchased($curr) ?
                            ($curr->TimesEntry) :
                            '-'
                        ),                                                                      // 20
                        $this->column ($curr->Extra_Name),                                      // 20
                        $this->column ($curr->BookingExtraPassenger_Code),                      // 14
                        $this->column ($curr->BookingExtraPassenger_Amount),                    // 14
                        $this->column (self::status($curr)),        // 14
                        $this->column ($curr->Seller_Name),                                                         // 20
                        $this->column ($curr->Id_Admin != NULL ? "$curr->Admin_Name $curr->Admin_LastName" : ''),   // 20
                        $this->column ($curr->BookingExtraPassenger_Remark), // 30
                    ];
                },
                $upgrades,
                array_keys ($upgrades)
            )
        );
    }

    public static function status ($bup) {
        switch ($bup->BookingExtraPassenger_Status) {
            case 2: return 'COMPRADO';
            case 1: return 'PENDIENTE';
            default: return 'ANULADO';
        }
    }

    public function purchased ($bep) {
        return $bep->BookingExtraPassenger_Status == 2;
    }
    
    public function run ($data, $oMetadata) {
        return $this->createUpgrades($data->Extra);
    }
    
}