<?php

namespace App\Providers\ExcelGroupReport;

class PassengerStyle {
    
    public static function border() { return [ 'action' => 'border' ]; }
    public static function bold()   { return [ 'action' => 'bold' ]; }
    public static function center() { return [ 'action' => 'center' ]; }

    public static function head () { return [ self::border(), self::bold(), self::center() ]; }
    public static function cell () { return [ self::border() ]; }


    public function run ($oGroup) {
        $height = 8;
        
        if($oGroup->Group_ServiceType==2){
            $height = 10;
        }
        if($oGroup->Group_ServiceType>2){
            $height = 11;
        }
        $height++;
        $oPassengers = $oGroup->Passenger;
        $result = [];
        for ($i = 0; $i < $height - 1; $i++) {
            $result[] = [];
        }
        $length=ceil(Count($oGroup->Providers) / 2);
        
        for ($i = 0; $i < $length; $i++) {
            $result[] = [];
        }  
        
        $result = array_merge( $result, $this->passengerFirst($oPassengers) );
        $result[] = [];
        $result[] = [];
        $result = array_merge( $result, $this->passengerSecond($oPassengers) );
        $result[] = [];
        if(count($oGroup->Group_Slaves)>0){
            $result[] = [];
        };
        for($i = 0; $i < count($oGroup->Group_Slaves); $i++){

            $result[] = [];
            $result[] = [];
            $result[] = [];
            $result[] = [];
            if($oGroup->Group_Slaves[$i]->Group_ServiceType==2){
                $result[] = [];
                $result[] = [];
            }
            if($oGroup->Group_Slaves[$i]->Group_ServiceType>2){
                $result[] = [];
                $result[] = [];
                $result[] = [];
            }
            $result = array_merge( $result, $this->Providers($oGroup->Group_Slaves[$i]->Providers) );
            $result[] = [];
            $result = array_merge( $result, $this->passengerFirst($oGroup->Group_Slaves[$i]->Passenger) );
            $result[] = [];
            $result[] = [];
            $result = array_merge( $result, $this->passengerSecond($oGroup->Group_Slaves[$i]->Passenger) );
        }
        return $result;
    }

    public function passengerFirst ($oPassengers) {
        $result = [ array_map ([self::class, 'head'],       [ '', '', '', '', '', '', '', '', '', '', '' ] ) ];

        foreach ($oPassengers as $p) {
            $result[] = array_map ([self::class, 'cell'],   [ '', '', '', '', '', '', '', '', '' , '', '']);
        }
        return $result;
    }

    public function passengerSecond ($oPassengers) {
        $result = [ array_map ([self::class, 'head'],       [ '', '', '', '', '', '', '', '', '' , ''] ) ];

        foreach ($oPassengers as $p) {
            $result[] = array_map ([self::class, 'cell'],   [ '', '', '', '', '', '', '', '', '', '' ]);
        }
        return $result;
    }

    public function Providers ($oProviders) {
        $length= ceil(Count($oProviders) / 2);
        $result=[];
        for($k = 0; $k < $length; $k++){	
            $result[] = [];
        }
        return $result;
    }

}