<?php

namespace App\Providers\ExcelProviderServiceReport;

use App\Http\Helpers\DateTime;

class ProviderServiceCells {

    private function title ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'border' ], [ 'action' => 'print', 'text' => $text ], ['action' => 'bold']]; }
    private function column ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'border' ], [ 'action' => 'print', 'text' => $text ]]; }

    private function createRows (array $list) {
        return array_reduce (
            $list,
            function ($carry, $cur) {
                return array_merge (
                    $carry,
                    $this->joinCM ($this->fillGroup ($this->mapGroup($cur), $cur), $this->mapCMD ($cur))
                );
            },
            []
        );
    }

    private function joinCM ($mapGroup, $mapCMD) {
        $turn = [];
        for ($i = 0; $i < count($mapGroup); $i++) {
            $turn[] = array_merge ($mapGroup[$i], $mapCMD[$i]);
        }
        return $turn;
    }

    private function mapGroup ($cur) {
        return [
            [
                $this->column($cur->Group_Name),
                $this->column($cur->GroupPassenger_PassengerCount),
                $this->column(DateTime::dateTransform($cur->Group_DateStart)),
                $this->column(DateTime::dateTransform($cur->Group_DateEnd)),
                $this->column($cur->Group_TourDuration),
                $this->column($cur->Provider_BusinessName),
                $this->column($cur->Provider_NoDocument),
            ]
        ];
    }
    
    private function fillGroup ($map, $cur) {
        return $this->fill ($map, count ($cur->Passenger));
    }

    private function fill ($arr, $length) {

        for ($i = count($arr); $i < $length; $i++) {
            $arr[$i] = [
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
            ];
        }
        return $arr;
    }

    private function mapCMD ($cur) {
        $estados= array('NO VIAJO', 'ANULADO','ACTIVO','DIO ALCANCE');
        if (count ($cur->Passenger) == 0) {
            return [
                [
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                ]
            ];
        } else {
            return array_map (
                function ($d) use($estados) {
                    return [
                        $this->column($d->Passenger_Name . ' ' . $d->Passenger_LastName),
                        $this->column($d->Passenger_Age),
                        $this->column($estados[$d->BookingTourPassenger_Status]),
                        $this->column($d->UserCountry_Code),
                        $this->column($d->Tour_Name),
                        $this->column($d->TypeDocument_Abrv . ': ' . $d->Passenger_NoDocument),
                        $this->column($d->Passenger_Email),
                        $this->column($d->Passenger_Gender == 1 ? 'M' : 'F'),
                    ];
                },
                $cur->Passenger
            );
        }
    }

    public function run ($oGroup, $oMetadata) {
        return array_merge (
            [
                [],
                [],
                [
                    $this->title('GRUPO'),
                    $this->title('PASAJEROS'),
                    $this->title('INICIO'),
                    $this->title('FINAL'),
                    $this->title('DURACIÓN'),
                    $this->title('PROVEEDOR'),
                    $this->title('N° DOC'),
                    $this->title('PASAJERO'),
                    $this->title('EDAD'),
                    $this->title('ESTADO'),
                    $this->title('PAIS'),
                    $this->title('TOUR'),
                    $this->title('DOCUMENTO'),
                    $this->title('CORREO'),
                    $this->title('SEXO'),
                ],
            ],
            $this->createRows($oGroup)
        );
    }
    
}