<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/externalUserPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerInsertController@__invoke'
    ]
);

$router->put(
    '/externalUserPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerUpdateController@__invoke'
    ]
);

$router->delete(
    '/externalUserPassenger/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerDeleteController@__invoke'
    ]
);

$router->get(
    '/externalUserPassenger/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerIndexController@__invoke'
    ]
);

$router->get(
    'externalUser/{IdExternalUser:[0-9]*}/externalUserPassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerListController@__invoke'
    ]
);
