<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/groupPassenger/all',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Insert_All'
    ]
);

$router->post(
    '/groupPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Insert'
    ]
);

$router->put(
    '/groupPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Update'
    ]
);

$router->delete(
    '/groupPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Delete'
    ]
);

$router->get(
    '/groupPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Index'
    ]
);

$router->get(
    '/group/{Id_Group}/groupPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@List'
    ]
);

$router->get(
    '/group/{Id_Group:[0-9]*}/groupPassengerWithReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupPassenger\\GroupPassengerListWithReviewController@__invoke'
    ]
);
