<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/groupProvider/all',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider\\InsertAll@__invoke'
    ]
);
$router->post(
    '/groupProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@insert'
    ]
);

$router->put(
    '/groupProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider\\Update@__invoke'
    ]
);

$router->put(
    '/groupProvider/remark',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@remark'
    ]
);

$router->delete(
    '/groupProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@delete'
    ]
);

$router->get(
    '/groupProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@index'
    ]
);

$router->get(
    '/group/{Id_Group}/groupProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@list'
    ]
);

$router->get(
    '/group/{Id_Group}/groupProvider/full',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@listFull'
    ]
);
