<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBooking\Domain\LeadBookingRepository;
use App\Modules\LeadBooking\Infraestructure\MysqlLeadBookingRepository;

$app->bind(LeadBookingRepository::class, fn($app) => $app->make(MysqlLeadBookingRepository::class));

$router->post(
    '/leadBooking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingInsertController@__invoke'
    ]
);

$router->put(
    '/leadBooking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBooking/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingDeleteController@__invoke'
    ]
);

$router->get(
    '/leadBooking/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingIndexController@__invoke'
    ]
);

$router->get(
    '/leadBooking/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingListController@__invoke'
    ]
);
