<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerRepository;
use App\Modules\LeadBookingServicePassenger\Infraestructure\MysqlLeadBookingServicePassengerRepository;

$router->post(
    '/leadBookingServicePassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerInsertController@__invoke'
    ]
);

$router->put(
    '/leadBookingServicePassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBookingServicePassenger/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerDeleteController@__invoke'
    ]
);

$router->get(
    '/leadBookingServicePassenger/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerIndexController@__invoke'
    ]
);

$router->get(
    '/leadBookingService/{Id_LeadBookingService:[0-9]*}/leadBookingServicePassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerListController@__invoke'
    ]
);

$app->bind(
    LeadBookingServicePassengerRepository::class,
    fn($app) => $app->make(MysqlLeadBookingServicePassengerRepository::class)
);
