<?php

namespace App\Config;

use App\Orm\Connection;
use App\Orm\ConnectionConfig;

class DatabaseConfig extends ConnectionConfig {
    /** @var string **/
    public $dbDriver;
    /** @var string */
    public $dbServer;
    /** @var string */
    public $dbUser;
    /** @var string */
    public $dbPassword;
    /** @var string */
    public $dbName;

    public function __construct (
        $dbDriver,
        $dbServer,
        $dbUser,
        $dbPassword,
        $dbName
    ) {
        $this->dbDriver = $dbDriver;
        $this->dbServer = $dbServer;
        $this->dbUser = $dbUser;
        $this->dbPassword = $dbPassword;
        $this->dbName = $dbName;
    }

    public static function db():Connection {
        $config = new self (
            getenv('DB_CONNECTION'),
            getenv('DB_HOST'),
            getenv('DB_USERNAME'),
            getenv('DB_PASSWORD'),
            getenv('DB_DATABASE')
        );

        return new Connection($config);
    }
}