<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class BookingTourMother {
    
    public static function buildShared1($Id_Booking, $Id_Package, $Id_Tour, $id = 1) {
        return [
            'Id_BookingTour' => $id,
            'BookingTour_DateStart' => date('Y-m-d'),
            'BookingTour_PickUp' => date('H:m:s'),
            'BookingTour_Type' => 3,
            'BookingTour_Type' => 1,
            'BookingTour_NoPax' => 2,
            'BookingTour_Name' => '',
            'BookingTour_TourName' => '',
            'BookingTour_Group' => 1,
            'BookingTour_TourDuration' => 5,
            'BookingTour_Status' => 2,
            'Id_Booking' => $Id_Booking,
            'Id_Package' => $Id_Package,
            'Id_Tour' => $Id_Tour
        ];
    }

    public static function pushShared1($Id_Booking, $Id_Package, $Id_Tour, $id = 1) {
        return self::push(self::buildShared1($Id_Booking, $Id_Package, $Id_Tour, $id));
    }

    private static function push($object) {
        DB::select("CALL `sp_booking_tour_insert` (?,?,?,?,?,?,?)", [
            $object['BookingTour_DateStart'],
            $object['BookingTour_Type'],
            $object['BookingTour_NoPax'],
            $object['Id_Package'],
            $object['Id_Booking'],
            $object['Id_Tour'],
            $object['Group'] 
        ]);
        return $object;
    }

}