<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class CityMother {
    
    public static function build1($idState, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_City'  			=> $id,            
            'City_Code'		    => Util::generateString(3),
            'City_Name'		    => $faker->text(rand(5, 250)),
            'City_Status'  		=> $faker->randomElement([1, 2]),
            'Id_State'          => $idState
        ];
    }

    public static function push1($idState, $id = 1) {
        return self::push(self::build1($idState, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_city_insert` (?,?,?,?)", [
            $object['City_Code'],
            $object['City_Name'],
            $object['City_Status'],
            $object['Id_State'],
        ]);
        $object['Id_City'] = $response[0]->Response_Id;
        return $object;
    }

}