<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class DirectoryMother {
    
    public static function build1($directorySelf, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_Directory'          => $id,
            'Directory_Name'        => $faker->text(rand(5, 255)),
            'Directory_Url'         => $faker->text(rand(5, 255)),
            'Directory_Icon'        => $faker->text(rand(5, 100)),
            'Directory_Order'       => 1,
            'Directory_Delete'      => $faker->randomElement([0, 1]),
            'Directory_Update'      => $faker->randomElement([0, 1]),
            'Directory_Insert'      => $faker->randomElement([0, 1]),
            'Directory_Self'        => $directorySelf,
        ];
    }

    public static function push1($directorySelf, $id = 1) {
        return self::push(self::build1($directorySelf, $id));
    }

    private static function push($object) {
        DB::statement("INSERT INTO `t_directory` (
            Directory_Name,
            Directory_Url,
            Directory_Icon,
            Directory_Order,
            Directory_Delete,
            Directory_Update,
            Directory_Insert,
            Directory_Self,
            Directory_Path
        ) VALUES (?,?,?,?,?,?,?,?,?)", [
            $object['Directory_Name'],
            $object['Directory_Url'],
            $object['Directory_Icon'],
            $object['Directory_Order'],
            $object['Directory_Delete'],
            $object['Directory_Update'],
            $object['Directory_Insert'],
            $object['Directory_Self'],
            ''
        ]);

        $response = DB::select('SELECT LAST_INSERT_ID() AS Response_Id')[0];
        $object['Id_Directory'] = $response->Response_Id;
        return $object;
    }

}