<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ExternalUserMother
{
    
    public static function build1($idExternal = null, $id = 1)
    {
        $idExternal = $idExternal ?? ExternalMother::push1()['Id_External'];
        $faker = Factory::create();
        return [
            'Id_ExternalUser' => $id,
            'ExternalUser_Date' => date('y-m-d H:i:s'),
            'ExternalUser_Name' => $faker->text(rand(5, 250)),
            'ExternalUser_LastName' => $faker->text(rand(5, 250)),
            'ExternalUser_NickName' => $faker->text(rand(5, 250)),
            'ExternalUser_Gender' => $faker->randomElement([1, 2]),
            'ExternalUser_Status' => $faker->randomElement([1, 2]),
            'Id_External' => $idExternal
        ];
    }

    public static function push1($idExternal = null, $id = 1)
    {
        return self::push(self::build1($idExternal, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_external_user_insert`(?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['ExternalUser_Name'],
            $object['ExternalUser_LastName'],
            $object['ExternalUser_NickName'],
            $object['ExternalUser_Gender'],
            $object['ExternalUser_Status'],
            $object['Id_External']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_ExternalUser'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::EXTERNAL_USER, ...ExternalMother::tablesToClear()];
    }
}
