<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class HtlUsageMother {
    
    public static function build1($idRoom, $id = 1, $usageStatus = NULL) {
        $faker = Factory::create();
        return [
            'Id_HtlUsage'			=> $id,
            'HtlUsage_DateUsage'    => date('Y-m-d', time() + rand(0, 2592000)),
            'HtlUsage_Status'       => $usageStatus !== NULL ? $usageStatus : $faker->randomElement([1, 2]),
            'HtlUsage_Name'         => $faker->text(rand(5,250)),
            'HtlUsage_LastName'     => $faker->text(rand(5,250)),
            'HtlUsage_Remark'       => $faker->text(rand(5,250)),
            'HtlUsage_Lock'         => 1,
            'Id_HtlRoom'            => $idRoom
        ];
    }

    public static function push1($idRoom, $id = 1, $usageStatus = NULL) {
        return self::push(self::build1($idRoom, $id, $usageStatus));
    }

    private static function push($object) {
        DB::select("CALL `sp_htl_usage_insert` (?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['HtlUsage_DateUsage'],
            $object['HtlUsage_Status'],
            $object['HtlUsage_Name'],
            $object['HtlUsage_LastName'],
            $object['HtlUsage_Remark'],
            $object['Id_HtlRoom'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_HtlUsage'] = $response[0]->{'@id'};
        }
        return $object;
    }

}