<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class LeadMother
{
    
    public static function build1($idTypeDocument = null, $idUserCountry = null, $id = 1)
    {
        $idTypeDocument = $idTypeDocument ?? TypeDocumentMother::push1()['Id_TypeDocument'];
        $idUserCountry = $idUserCountry ?? UserCountryMother::push1()['Id_UserCountry'];
        $faker = Factory::create();
        return [
            'Id_Lead' => $id,
            'Lead_Date' => date('Y-m-d H:i:s'),
            'Lead_Name' => $faker->text(rand(5, 100)),
            'Lead_LastName' => $faker->text(rand(5, 100)),
            'Lead_Gender' => $faker->randomElement([1, 2]),
            'Lead_Email' => $faker->email,
            'Lead_PhoneCode' => Util::generateString(4),
            'Lead_Phone' => $faker->text(rand(5, 20)),
            'Lead_NoDocument' => $faker->text(rand(5, 50)),
            'Lead_Address' => $faker->text(rand(5, 250)),
            'Lead_ContactName' => $faker->text(rand(5, 250)),
            'Lead_ContactPhone' => $faker->text(rand(5, 20)),
            'Lead_Type' => $faker->randomElement([1, 2]),
            'Lead_Status' => $faker->randomElement([1, 2]),
            'Id_TypeDocument' => $idTypeDocument,
            'Id_UserCountry' => $idUserCountry,
        ];
    }

    public static function push1($idTypeDocument = null, $idUserCountry = null, $id = 1)
    {
        return self::push(self::build1($idTypeDocument, $idUserCountry, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_lead_insert`(?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['Lead_Name'],
            $object['Lead_LastName'],
            $object['Lead_Gender'],
            $object['Lead_Email'],
            $object['Lead_PhoneCode'],
            $object['Lead_Phone'],
            $object['Lead_NoDocument'],
            $object['Lead_Address'],
            $object['Lead_ContactName'],
            $object['Lead_ContactPhone'],
            $object['Lead_Type'],
            $object['Lead_Status'],
            $object['Id_TypeDocument'],
            $object['Id_UserCountry'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_Lead'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::LEAD, TC::user_country, ...TypeDocumentMother::tablesToClear() ];
    }
}
