<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class PassengerReviewMother
{
    
    public static function build1(
        $idProvider,
        $idTypeProvider,
        $idBookingTourPassenger,
        $idTour,
        $idQuestion,
        $idGroup,
        $id = 1
    ) {
        $faker = Factory::create();
        return [
            'Id_PassengerReview'            => $id,
            'PassengerReview_Date'          => date('Y-m-d H:i:s'),
            'PassengerReview_DateUpdate'    => date('Y-m-d H:i:s'),
            'PassengerReview_Answered'      => $faker->randomElement([0, 1]),
            'PassengerReview_Status'        => $faker->randomElement([1, 2]),
            'PassengerReview_Score'         => $faker->randomElement([1, 2, 3, 4, 5]),
            'PassengerReview_Comment'       => $faker->text(rand(5, 200)),
            'PassengerReview_Values'        => '[]',
            'PassengerReview_Provider'      => $idProvider,
            'Id_TypeProvider'               => $idTypeProvider,
            'Id_BookingTourPassenger'       => $idBookingTourPassenger,
            'Id_Tour'                       => $idTour,
            'Id_Question'                   => $idQuestion,
            'Id_Group'                      => $idGroup,
        ];
    }

    public static function push1(
        $idProvider,
        $idTypeProvider,
        $idBookingTourPassenger,
        $idTour,
        $idQuestion,
        $idGroup,
        $id = 1
    ) {
        return self::push(self::build1(
            $idProvider,
            $idTypeProvider,
            $idBookingTourPassenger,
            $idTour,
            $idQuestion,
            $idGroup,
            $id
        ));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_passenger_review_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['PassengerReview_Date'],
            $object['PassengerReview_DateUpdate'],
            $object['PassengerReview_Answered'],
            $object['PassengerReview_Score'],
            $object['PassengerReview_Comment'],
            $object['PassengerReview_Values'],
            $object['PassengerReview_Provider'],
            $object['Id_TypeProvider'],
            $object['Id_BookingTourPassenger'],
            $object['Id_Tour'],
            $object['Id_Question'],
            $object['Id_Group']
        ]);
        $object['Id_PassengerReview'] = $response[0]->Response_Id;
        return $object;
    }
}
