<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class StateMother {
    
    public static function build1($idCountry = null, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_State'  			=> $id,
            'State_Code'		    => Util::generateString(3),
            'State_Name'		    => $faker->text(rand(5, 250)),
            'State_Status'  		=> $faker->randomElement([1, 2]),
            'Id_Country'            => $idCountry !== null ? $idCountry : CountryMother::push1()['Id_Country'],
        ];
    }

    public static function push1($idCountry = null, $id = 1) {
        return self::push(self::build1($idCountry, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_state_insert` (?,?,?,?)", [
            $object['State_Code'],
            $object['State_Name'],
            $object['State_Status'],
            $object['Id_Country']
        ]);
        $object['Id_State'] = $response[0]->Response_Id;
        return $object;
    }

    public static function tablesToClear() {
        return [ TC::state ];
    }

}