<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TourHtlCampMother {
    
    public static function build1($idTour, $idHtlCamp, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_TourHtlCamp'			=> $id,
            'TourHtlCamp_Day'		    => rand(1, 10),
            'TourHtlCamp_Status'		=> $faker->randomElement([1, 2]),
            'Id_Tour'		            => $idTour,
            'Id_HtlCamp'		        => $idHtlCamp
        ];
    }

    public static function push1($idTour, $idHtlCamp, $id = 1) {
        return self::push(self::build1($idTour, $idHtlCamp, $id));
    }

    private static function push($object) {
        DB::select("CALL `sp_tour_htl_camp_insert` (?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['TourHtlCamp_Day'],
            $object['TourHtlCamp_Status'],
            $object['Id_Tour'],
            $object['Id_HtlCamp'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_TourHtlCamp'] = $response[0]->{'@id'};
        }
        return $object;
    }

}