<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TourTranslMother {

    public static function build1($idTour, $idLanguage, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_TourTransl' => $id,
            'TourTransl_Title' => Str::title($faker->text(rand(5, 250))),
            'Id_Tour' => $idTour,
            'Id_Language' => $idLanguage
        ];
    }

    public static function push1($idTour, $idLanguage, $id = 1) {
        return self::push(self::build1($idTour, $idLanguage, $id));
    }
    
    private static function push($object) {
        DB::select("CALL `sp_tour_transl_insert` (?,?,?,?)", [
            $object['TourTransl_Title'],
            $object['Id_Tour'],
            $object['Id_Language'],
            1
        ]);
        return $object;
    }

}