<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TypeRateMother {
    
    public static function build1($id = 1) {
        $faker = Factory::create();
        return [
            'Id_TypeRate' => $id,
            'TypeRate_Name' => $faker->text(rand(5, 250)),
            'TypeRate_Abrv' => Str::upper(Util::generateString(4)),
            'TypeRate_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_type_rate_insert` (?,?,?)", [
            $object['TypeRate_Name'],
            $object['TypeRate_Abrv'],
            $object['TypeRate_Status']
        ]);
        $object['Id_TypeRate'] = $response[0]->Response_Id;
        return $object;
    }

}