<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TypeUpgradeMother
{
    
    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_TypeUpgrade'       => $id,
            'TypeUpgrade_Name'     => Str::title($faker->text(rand(5, 100))),
            'TypeUpgrade_Abrv'     => Str::upper(Util::generateString(4)),
            'TypeUpgrade_Lock'     => $faker->randomElement([0, 1]),
            'TypeUpgrade_Status'   => 2
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_type_upgrade_insert` (?,?,?)", [
            $object['TypeUpgrade_Name'],
            $object['TypeUpgrade_Abrv'],
            $object['TypeUpgrade_Status']
        ]);
        $object['Id_TypeUpgrade'] = $response[0]->Response_Id;
        return $object;
    }
}
