<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class PackageMother {

    public static function buildClassic5($id = 1) {
        return [
            'Id_Package' => $id,
            'Package_Code' => 'P5',
            'Package_Name' => 'Package 5',
            'Package_UrlThumbnail' => '',
            'Package_Duration' => 3,
            'Package_Availability' => 10,
            'Package_PaxRequired' => 1,
            'Package_DOBRequired' => 1,
            'Package_Status' => 2,
            'Package_Endorser' => 2,
            'Package_Duration' => 0
        ];
    }

    public static function pushClassic5($id = 1) {
        return self::push(self::buildClassic5($id));
    }
    
    public static function buildClassic4($id = 1) {
        return [
            'Id_Package' => $id,
            'Package_Code' => 'P4',
            'Package_Name' => 'Package 4',
            'Package_UrlThumbnail' => '',
            'Package_Duration' => 3,
            'Package_Availability' => 10,
            'Package_PaxRequired' => 1,
            'Package_DOBRequired' => 1,
            'Package_Status' => 2,
            'Package_Endorser' => 2,
            'Package_Duration' => 0
        ];
    }

    public static function pushClassic4($id = 1) {
        return self::push(self::buildClassic4($id));
    }

    private static function push($object) {
        DB::select("CALL `sp_package_insert` (?,?,?,?,?,?,?,?,?)", [
            $object['Package_Name'],
            $object['Package_Code'],
            $object['Package_UrlThumbnail'],
            $object['Package_Availability'],
            $object['Package_PaxRequired'],
            $object['Package_DOBRequired'],
            $object['Package_Status'],
            $object['Package_Endorser'],
            $object['Package_Duration']
        ]);

        return $object;
    }

}