<?php

namespace App\DBTestSupport;

use App\Config\DatabaseConfig;


class TableCreation {

    private static $createdTables = [];

    public static function reset () {
        self::$createdTables = [];
        $db = DatabaseConfig::db();
        $db->query ("SET FOREIGN_KEY_CHECKS = 0;
            SET GROUP_CONCAT_MAX_LEN=32768;
            SET @tables = NULL;
            SELECT GROUP_CONCAT('`', table_name, '`') INTO @tables
            FROM information_schema.tables
            WHERE table_schema = (SELECT DATABASE());        
            SELECT IFNULL(@tables,'dummy') INTO @tables;

            SET @tables = CONCAT('DROP TABLE IF EXISTS ', @tables);
            PREPARE stmt FROM @tables;
            EXECUTE stmt;
            DEALLOCATE PREPARE stmt;
            SET FOREIGN_KEY_CHECKS = 1");
        
    }
    
    public static function createTable ($tableName) {
        
        if (array_key_exists($tableName, self::$createdTables)) {
            return;
        }
        
        $sqlDir = self::sqlDir();

        $tableDir = $sqlDir . $tableName . '.sql';
        $content = file_get_contents ($tableDir);
        
        $db = DatabaseConfig::db();
        $db->query ($content);
        self::$createdTables[$tableName] = true;
    }

    public static function cDatabase () {
        self::createTable('db_salkantay');
    }

    public static function sqlDir ():string {
        $cut = DIRECTORY_SEPARATOR;
        return __DIR__ . "$cut";
    }
}