<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;

class c_Schedule_Detail extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Schedule Detail";
    }
    
	public function List (Request $Request, $Id_Schedule) {
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id ($Id_Schedule, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oData  = DB::select('call sp_schedule_detail_list(?)', [ $Id_Schedule ]);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list " . $Id_Schedule;
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	
}