<?php
namespace App\Http\Controllers\Owner\External;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\External\Application\ExternalUpdater;
use App\Modules\External\Domain\IdExternal;
use App\Modules\External\Domain\External;
use App\Modules\External\Domain\ExternalAbrv;
use App\Modules\External\Domain\ExternalAsset;
use App\Modules\External\Domain\ExternalLock;
use App\Modules\External\Domain\ExternalName;
use App\Modules\External\Domain\ExternalStatus;
use App\Modules\External\Infraestructure\MysqlExternalRepository;
use App\Modules\External\Infraestructure\ExternalValidators;

class ExternalUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->domain = "External";
        $this->history = new HistoryData(HistoryTables::EXTERNAL);
    }

    public function __invoke(Request $Request)
    {
        (new LaravelValidator())->validate($Request->all(), $this->domain, ExternalValidators::INSERT);

        $this->history->obtainOld($Request->input("Id_External"));

        $response = (new ExternalUpdater(new MysqlExternalRepository()))
            ->__invoke(new External(
                new ExternalName(trim($Request->input('External_Name'))),
                new ExternalAbrv(trim($Request->input('External_Abrv'))),
                new ExternalAsset($Request->input('External_Asset')),
                new ExternalLock(ExternalLock::ANSWER_NO),
                new ExternalStatus($Request->input('External_Status')),
                new IdExternal($Request->input('Id_External'))
            ));

        $this->history->updateBasic($Request->input("Id_External"), $Request);

        return ResponseBuilder::Response($response);
    }
}
