<?php
namespace App\Http\Controllers\Owner\Lead;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Lead\Application\Index\LeadIndexerQuery;
use App\Modules\Lead\Application\Index\LeadIndexerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var LeadIndexerResponse $response */
        $response = $this->queryBus->ask(new LeadIndexerQuery($Id));

        return ResponseBuilder::Response($response->response());
    }
}
