<?php
namespace App\Http\Controllers\Owner\LeadBookingService;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBookingService\Application\Index\LeadBookingServiceIndexerQuery;
use App\Modules\LeadBookingService\Application\Index\LeadBookingServiceIndexerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServiceIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var LeadBookingServiceIndexerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServiceIndexerQuery($Id));

        return ResponseBuilder::Response($response->response());
    }
}
