<?php
namespace App\Http\Controllers\Owner\LeadBookingService;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingService\Application\Create\LeadBookingServiceInserterQuery;
use App\Modules\LeadBookingService\Application\Create\LeadBookingServiceInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingService\Infraestructure\LeadBookingServiceValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServiceInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingService";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_SERVICE);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingServiceValidators::INSERT);
        
        /** @var LeadBookingServiceInserterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServiceInserterQuery(
            $request->input('LeadBookingService_Quantity'),
            $request->input('LeadBookingService_Type'),
            $request->input('LeadBookingService_Status'),
            $request->input('Id_LeadBookingTour'),
            $request->input('Id')
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
