<?php
namespace App\Http\Controllers\Owner\LeadBookingTourPassenger;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBookingTourPassenger\Application\Index\LeadBookingTourPassengerIndexerQuery;
use App\Modules\LeadBookingTourPassenger\Application\Index\LeadBookingTourPassengerIndexerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourPassengerIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var LeadBookingTourPassengerIndexerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourPassengerIndexerQuery($Id));

        return ResponseBuilder::Response($response->response());
    }
}
