<?php
namespace App\Http\Controllers\Owner\LeadBookingTourPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingTourPassenger\Application\Create\LeadBookingTourPassengerInserterQuery;
use App\Modules\LeadBookingTourPassenger\Application\Create\LeadBookingTourPassengerInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingTourPassenger\Infraestructure\LeadBookingTourPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourPassengerInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingTourPassenger";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_TOUR_PASSENGER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingTourPassengerValidators::INSERT);
        /** @var LeadBookingTourPassengerInserterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourPassengerInserterQuery(
            $request->input('LeadBookingTourPassenger_Status'),
            $request->input('Id_LeadBookingTour'),
            $request->input('Id_LeadPassenger')
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
